<!DOCTYPE html>
<html>
<head>
<title>Dashboard Kelembaban + PIR</title>
<link rel="stylesheet" href="style.css">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
</head>

<body>

<div class="header">
    <h2>🌱 IoT Soil Moisture + PIR Dashboard</h2>
    <p>Monitoring Kelembaban & Gerakan Realtime</p>
</div>

<div class="container">

    <!-- Card Kelembaban -->
    <div class="card">
        <h3>Kelembaban Saat Ini</h3>
        <div id="nilai" class="value">0%</div>
    </div>

    <!-- Card Status Tanah -->
    <div class="card">
        <h3>Status Tanah</h3>
        <div id="status" class="value status">Memuat...</div>
    </div>

    <!-- Card PIR -->
    <div class="card">
        <h3>Deteksi Gerakan</h3>
        <div id="pir_status" class="value pir">Memuat...</div>
    </div>

</div>

<!-- Grafik Kelembaban -->
<div class="chart-box">
    <h3>Grafik Kelembaban Tanah</h3>
    <canvas id="chartKelembaban"></canvas>
</div>

<!-- Grafik PIR -->
<div class="chart-box">
    <h3>Grafik Deteksi Gerakan PIR</h3>
    <canvas id="chartPIR"></canvas>
</div>

<script>
let ctx1 = document.getElementById('chartKelembaban').getContext('2d');
let ctx2 = document.getElementById('chartPIR').getContext('2d');

// Grafik kelembaban
let chartKelembaban = new Chart(ctx1, {
    type: 'line',
    data: {
        labels: [],
        datasets: [{
            label: 'Kelembaban (%)',
            data: [],
            borderWidth: 3,
            fill: true,
            tension: 0.3
        }]
    }
});

// Grafik PIR
let chartPIR = new Chart(ctx2, {
    type: 'bar',
    data: {
        labels: [],
        datasets: [{
            label: 'Deteksi Gerakan (1 = Ada Gerakan)',
            data: [],
            borderWidth: 2
        }]
    },
    options: {
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    stepSize: 1
                }
            }
        }
    }
});



// UPDATE GRAFIK & CARD TIAP 3 DETIK
setInterval(() => {

    // -------- KELEMBABAN --------
    fetch("data.php")
        .then(res => res.json())
        .then(data => {

            let labels = data.map(d => d.waktu);
            let values = data.map(d => d.kelembaban);
            let lastValue = values.length > 0 ? values[0] : 0;

            // Card nilai
            document.getElementById("nilai").innerHTML = lastValue + "%";

            // Status tanah
            let status = "Tidak Ada Data";
            if (lastValue > 70) status = "Basah 💧";
            else if (lastValue > 40) status = "Normal 🌿";
            else status = "Kering ⚠️";

            document.getElementById("status").innerHTML = status;

            // Update grafik
            chartKelembaban.data.labels = labels.reverse();
            chartKelembaban.data.datasets[0].data = values.reverse();
            chartKelembaban.update();
        });

    // -------- PIR --------
    fetch("data_pir.php")
        .then(res => res.json())
        .then(data => {

            let labels = data.map(d => d.waktu);
            let values = data.map(d => d.gerakan);
            let lastValue = values.length > 0 ? values[0] : 0;

            // Card PIR
            if (lastValue == 1)
                document.getElementById("pir_status").innerHTML = "ADA GERAKAN 🚨";
            else
                document.getElementById("pir_status").innerHTML = "Tidak Ada Gerakan";

            // Update grafik PIR
            chartPIR.data.labels = labels.reverse();
            chartPIR.data.datasets[0].data = values.reverse();
            chartPIR.update();
        });

}, 3000);
</script>

</body>
</html>
