<?php
// 1. Hubungkan ke Database menggunakan file yang baru ditemukan
include "config/conn.php"; 

// 2. Panggil Library TCPDF
require_once('tcpdf/tcpdf.php');

// 3. Inisialisasi TCPDF
$pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Sistem Absensi Siswa');
$pdf->SetTitle('Laporan Absensi');

// Hilangkan Header & Footer bawaan agar rapi
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Tambah Halaman
$pdf->AddPage();

// 4. Judul Laporan
$pdf->SetFont('helvetica', 'B', 14);
$pdf->Cell(0, 10, 'LAPORAN DATA ABSENSI SISWA', 0, 1, 'C');
$pdf->Ln(5);

// 5. Struktur Tabel HTML
$pdf->SetFont('helvetica', '', 10);
$html = '
<table border="1" cellpadding="5">
    <thead>
        <tr style="background-color: #dfdfdf; font-weight: bold;">
            <th width="10%" align="center">No</th>
            <th width="20%" align="center">NIS</th>
            <th width="35%">Nama Siswa</th>
            <th width="15%" align="center">Kelas</th>
            <th width="20%" align="center">Keterangan</th>
        </tr>
    </thead>
    <tbody>';

// 6. Ambil Data (Query menyesuaikan dengan tabel di sisabsi)
$no = 1;
// Pastikan variabel koneksi di $koneksi adalah $koneksi atau $conn
// Jika nanti error, cek isi file config/$koneksi tersebut
$sql = "SELECT a.*, s.nama_siswa, s.nis, k.nama_kelas 
        FROM absen a 
        JOIN siswa s ON a.id_siswa = s.id_siswa 
        JOIN kelas k ON s.id_kelas = k.id_kelas
        ORDER BY a.id_absen DESC";

// Ganti $conn di bawah ini jika di file $koneksi kamu menggunakan nama lain (misal $koneksi)
$query = mysqli_query($conn, $sql); 

if($query && mysqli_num_rows($query) > 0) {
    while($data = mysqli_fetch_assoc($query)) {
        $html .= '
        <tr>
            <td align="center">'.$no++.'</td>
            <td align="center">'.$data['nis'].'</td>
            <td>'.$data['nama_siswa'].'</td>
            <td align="center">'.$data['nama_kelas'].'</td>
            <td align="center">'.$data['keterangan'].'</td>
        </tr>';
    }
} else {
    $html .= '<tr><td colspan="5" align="center">Data tidak ditemukan atau terjadi kesalahan koneksi</td></tr>';
}

$html .= '</tbody></table>';

// 7. Masukkan HTML ke PDF
$pdf->writeHTML($html, true, false, true, false, '');

// 8. Cetak ke Browser
$pdf->Output('Laporan_Absensi_Siswa.pdf', 'I');
?>