<?php
include "config/conn.php"; // Pastikan koneksi database

$tgl_hari_ini = date("Y-m-d");

// 1. HITUNG DATA UNTUK WIDGET ATAS
$jml_siswa = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM siswa"));
$jml_guru  = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM guru"));
$jml_kelas = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM kelas"));
$jml_mapel = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM mata_pelajaran"));

// 2. HITUNG DATA ABSENSI HARI INI
$hadir = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM absen WHERE tgl='$tgl_hari_ini' AND ket='M'"));
$izin  = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM absen WHERE tgl='$tgl_hari_ini' AND ket='I'"));
$sakit = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM absen WHERE tgl='$tgl_hari_ini' AND ket='S'"));
$alpa  = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM absen WHERE tgl='$tgl_hari_ini' AND ket='A'"));

// Hitung persentase kehadiran (Opsional)
$total_absen_masuk = $hadir + $izin + $sakit + $alpa;
$persen_hadir = ($total_absen_masuk > 0) ? round(($hadir / $jml_siswa) * 100) : 0;
?>

<style>
    .panel-stat { border: none; border-radius: 4px; color: white; position: relative; overflow: hidden; margin-bottom: 20px; }
    .panel-stat .huge { font-size: 40px; font-weight: bold; line-height: normal; }
    .panel-stat .stat-label { font-size: 14px; opacity: 0.8; text-transform: uppercase; letter-spacing: 1px; }
    .panel-stat .icon-bg { position: absolute; top: 10px; right: 20px; font-size: 70px; opacity: 0.2; transform: rotate(-10deg); }
    
    /* Warna Warni Dashboard */
    .bg-blue   { background: linear-gradient(45deg, #1e88e5, #42a5f5); } /* Siswa */
    .bg-green  { background: linear-gradient(45deg, #43a047, #66bb6a); } /* Guru */
    .bg-indigo { background: linear-gradient(45deg, #3949ab, #5c6bc0); } /* Hadir */
    .bg-red    { background: linear-gradient(45deg, #e53935, #ef5350); } /* Alpa/Tidak Masuk */
    .bg-orange { background: linear-gradient(45deg, #fb8c00, #ffa726); } /* Terlambat/Izin */
    .bg-teal   { background: linear-gradient(45deg, #00897b, #26a69a); } /* Kelas */
    .bg-pink   { background: linear-gradient(45deg, #d81b60, #ec407a); } /* Sakit */
    
    .panel-footer-custom { background: rgba(0,0,0,0.1); color: white; border: none; }
    .panel-footer-custom:hover { background: rgba(0,0,0,0.2); text-decoration: none; color: white; }
</style>

<div class="row mb-3">
    <div class="col-lg-12">
        <h3 class="page-header"><strong>Dashboard Monitoring</strong> <small><?= date('d F Y') ?></small></h3>
    </div>
</div>

<div class="row">
    <div class="col-lg-3 col-md-6">
        <div class="panel panel-stat bg-blue">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-users icon-bg"></i>
                    </div>
                    <div class="col-xs-12 text-right">
                        <div class="huge"><?= $jml_siswa ?></div>
                        <div class="stat-label">Total Siswa</div>
                    </div>
                </div>
            </div>
            <a href="media.php?module=siswa&kls=semua">
                <div class="panel-footer panel-footer-custom">
                    <span class="pull-left">Lihat Detail</span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="panel panel-stat bg-green">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-graduation-cap icon-bg"></i>
                    </div>
                    <div class="col-xs-12 text-right">
                        <div class="huge"><?= $jml_guru ?></div>
                        <div class="stat-label">Total Guru</div>
                    </div>
                </div>
            </div>
            <a href="media.php?module=guru">
                <div class="panel-footer panel-footer-custom">
                    <span class="pull-left">Lihat Detail</span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="panel panel-stat bg-teal">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-building icon-bg"></i>
                    </div>
                    <div class="col-xs-12 text-right">
                        <div class="huge"><?= $jml_kelas ?></div>
                        <div class="stat-label">Total Kelas</div>
                    </div>
                </div>
            </div>
            <a href="media.php?module=kelas">
                <div class="panel-footer panel-footer-custom">
                    <span class="pull-left">Lihat Detail</span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="panel panel-stat bg-indigo">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-book icon-bg"></i>
                    </div>
                    <div class="col-xs-12 text-right">
                        <div class="huge"><?= $jml_mapel ?></div>
                        <div class="stat-label">Mata Pelajaran</div>
                    </div>
                </div>
            </div>
            <a href="media.php?module=mata_pelajaran">
                <div class="panel-footer panel-footer-custom">
                    <span class="pull-left">Lihat Detail</span>
                    <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                    <div class="clearfix"></div>
                </div>
            </a>
        </div>
    </div>
</div>

<hr>
<h4><strong>Statistik Kehadiran Hari Ini (<?= date('d-m-Y') ?>)</strong></h4>

<div class="row">
    <div class="col-lg-3 col-md-6">
        <div class="panel panel-stat bg-teal">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-check-square-o icon-bg"></i>
                    </div>
                    <div class="col-xs-12 text-right">
                        <div class="huge"><?= $hadir ?></div>
                        <div class="stat-label">Siswa Hadir</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="panel panel-stat bg-orange">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-envelope-open-o icon-bg"></i>
                    </div>
                    <div class="col-xs-12 text-right">
                        <div class="huge"><?= $izin ?></div>
                        <div class="stat-label">Siswa Izin</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="panel panel-stat bg-pink">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-medkit icon-bg"></i>
                    </div>
                    <div class="col-xs-12 text-right">
                        <div class="huge"><?= $sakit ?></div>
                        <div class="stat-label">Siswa Sakit</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-lg-3 col-md-6">
        <div class="panel panel-stat bg-red">
            <div class="panel-heading">
                <div class="row">
                    <div class="col-xs-3">
                        <i class="fa fa-times-circle icon-bg"></i>
                    </div>
                    <div class="col-xs-12 text-right">
                        <div class="huge"><?= $alpa ?></div>
                        <div class="stat-label">Tidak Masuk (Alpa)</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="panel panel-default">
            <div class="panel-heading">
                <i class="fa fa-bar-chart-o fa-fw"></i> Grafik Kehadiran Hari Ini
            </div>
            <div class="panel-body">
                <canvas id="absenChart" style="width: 100%; height: 300px;"></canvas>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="panel panel-default">
            <div class="panel-heading">
                <i class="fa fa-pie-chart fa-fw"></i> Persentase Kehadiran
            </div>
            <div class="panel-body">
                <canvas id="persenChart" style="width: 100%; height: 300px;"></canvas>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    // 1. Grafik Batang (Bar Chart)
    var ctx = document.getElementById('absenChart').getContext('2d');
    var absenChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['Hadir', 'Izin', 'Sakit', 'Alpa'],
            datasets: [{
                label: 'Jumlah Siswa',
                data: [<?= $hadir ?>, <?= $izin ?>, <?= $sakit ?>, <?= $alpa ?>],
                backgroundColor: [
                    'rgba(75, 192, 192, 0.7)', // Teal
                    'rgba(255, 159, 64, 0.7)', // Orange
                    'rgba(255, 99, 132, 0.7)', // Pink
                    'rgba(255, 0, 0, 0.7)'     // Merah
                ],
                borderColor: [
                    'rgba(75, 192, 192, 1)',
                    'rgba(255, 159, 64, 1)',
                    'rgba(255, 99, 132, 1)',
                    'rgba(255, 0, 0, 1)'
                ],
                borderWidth: 1
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // 2. Grafik Lingkaran (Doughnut Chart)
    var ctx2 = document.getElementById('persenChart').getContext('2d');
    var persenChart = new Chart(ctx2, {
        type: 'doughnut',
        data: {
            labels: ['Masuk', 'Tidak Masuk'],
            datasets: [{
                data: [<?= $hadir + $izin ?>, <?= $sakit + $alpa ?>],
                backgroundColor: ['#42a5f5', '#ef5350'],
            }]
        }
    });
</script>