<?php
// Cek mode: Apakah TAMBAH BARU atau EDIT?
$act = isset($_GET['act']) ? $_GET['act'] : '';
$idg = isset($_GET['idg']) ? $_GET['idg'] : '';

if ($act == "edit" && !empty($idg)) {
    $judul = "Edit Data Guru";
    // Ambil data guru yang mau diedit
    $query = mysqli_query($koneksi, "SELECT * FROM guru WHERE idg='$idg'");
    $data  = mysqli_fetch_assoc($query);
    
    // Set nilai awal form (untuk edit)
    $nip_val    = $data['nip'];
    $nama_val   = $data['nama'];
    $jk_val     = $data['jk'];
    $alamat_val = $data['alamat'];
    
    // Action form mengarah ke EDIT
    $form_action = "./module/simpan.php?act=edit_guru";
} else {
    $judul = "Input Data Guru";
    // Nilai awal kosong (untuk input baru)
    $nip_val    = "";
    $nama_val   = "";
    $jk_val     = "L"; // Default Laki-laki
    $alamat_val = "";
    
    // Action form mengarah ke INPUT
    $form_action = "./module/simpan.php?act=input_guru";
}
?>

<div class="row mb-3">
    <div class="col-lg-12">
        <h3 class="page-header"><strong><?= $judul ?></strong></h3>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="panel panel-primary">
            <div class="panel-heading"><?= $judul ?></div>
            <div class="panel-body">
                
                <form method="post" action="<?= $form_action ?>">
                    <?php if ($act == "edit") { ?>
                        <input type="hidden" name="idg" value="<?= $idg ?>">
                    <?php } ?>

                    <div class="form-group">
                        <label>NIP / NUPTK / Kode Guru</label>
                        <input type="text" name="nip" class="form-control" value="<?= $nip_val ?>" placeholder="Masukan NIP (Boleh dikosongkan atau isi - jika tidak ada)">
                        <p class="help-block text-danger" style="font-size: 12px;">*Jika tidak memiliki NIP, boleh dikosongkan atau isi dengan NUPTK/Kode Unik agar bisa Login.</p>
                    </div>

                    <div class="form-group">
                        <label>Nama Lengkap</label>
                        <input type="text" name="nama" class="form-control" value="<?= $nama_val ?>" required placeholder="Nama Lengkap Guru">
                    </div>

                    <div class="form-group">
                        <label>Jenis Kelamin</label><br>
                        <label class="radio-inline">
                            <input type="radio" name="jk" value="L" <?= ($jk_val == 'L') ? 'checked' : '' ?>> Laki - Laki
                        </label>
                        <label class="radio-inline">
                            <input type="radio" name="jk" value="P" <?= ($jk_val == 'P') ? 'checked' : '' ?>> Perempuan
                        </label>
                    </div>

                    <div class="form-group">
                        <label>Alamat</label>
                        <textarea name="alamat" class="form-control" rows="3"><?= $alamat_val ?></textarea>
                    </div>

                    <div class="form-group">
                        <label>Password Login</label>
                        <input type="text" name="password" class="form-control" placeholder="<?= ($act=='edit') ? 'Kosongkan jika tidak ingin mengubah password' : 'Wajib diisi untuk login' ?>" <?= ($act!='edit') ? 'required' : '' ?>>
                    </div>

                    <button type="submit" class="btn btn-success">
                        <i class="fa fa-save"></i> Simpan
                    </button>
                    <a href="media.php?module=guru" class="btn btn-danger">Batal</a>
                </form>

            </div>
        </div>
    </div>
</div>