<?php
session_start();
// Cek Login
if(!empty($_SESSION['nama'])){
    $uidi  = $_SESSION['idu'];
    $usre  = $_SESSION['nama'];
    $level = $_SESSION['level'];
    $idd   = $_SESSION['id'];

    include_once "config/conn.php";
    include_once "config/fungsi.php";

    $db = isset($koneksi) ? $koneksi : $conn;
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SISTEM ABSENSI SISWA</title>

    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="font-awesome/css/font-awesome.css" rel="stylesheet">
    <link href="css/plugins/dataTables/dataTables.bootstrap.css" rel="stylesheet">
    <link href="css/sb-admin.css" rel="stylesheet">
    
    <script type="text/javascript">
      var detik=<?php echo date('s'); ?>;
      var menit=<?php echo date('i'); ?>;
      var jam=<?php echo date('H'); ?>;
      function clock() {
        if (detik!=0 && detik%60==0) { menit++; detik=0; }
        if (menit!=0 && menit%60==0) { jam++; menit=0; }
        if (jam!=0 && jam%24==0) { jam=0; }
        var second = detik < 10 ? '0'+detik : detik;
        var minute = menit < 10 ? '0'+menit : menit;
        var hour   = jam < 10 ? '0'+jam : jam;
        if(document.getElementById("clock")){
            document.getElementById("clock").innerHTML = hour+':'+minute+':'+second;
        }
        detik++;
      }
      setInterval(clock,1000);
    </script>
    <style>
      .bg-cetak-baru { background-color: #ff0000 !important; border-bottom: 3px solid #ac2925; margin: 10px; border-radius: 5px; }
      .bg-cetak-baru a { color: white !important; font-weight: bold !important; text-align: center; padding: 10px !important; }
    </style>
</head>

<body>
    <div id="wrapper">
        <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="margin-bottom: 0">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".sidebar-collapse">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span><span class="icon-bar"></span><span class="icon-bar"></span>
                </button>
                <a class="navbar-brand" href="media.php?module=home">SISTEM ABSENSI SISWA</a>
            </div>

            <ul class="nav navbar-top-links navbar-right">
                <li><a><i class="fa fa-user fa-fw"></i> <?php echo $usre; ?> (<?php echo ucfirst($level); ?>)</a></li>
                <li><a><i class="fa fa-calendar fa-fw"></i> <?php echo tgl_ina(date("Y-m-d")); ?> | <span id='clock'></span></a></li>
                <li><a href="logout.php"><i class="fa fa-sign-out fa-fw"></i> Logout</a></li>
            </ul>

            <div class="navbar-default navbar-static-side" role="navigation">
                <div class="sidebar-collapse">
                    <ul class="nav" id="side-menu">
                        <li><a href="media.php?module=home"><i class="fa fa-home fa-fw"></i> Dashboard</a></li>
                        
                        <?php if($level=='admin' || $level=='guru'){ ?>
                        <li class="bg-cetak-baru"><a href="media.php?module=cetak_filter"><i class="fa fa-print fa-fw"></i> MENU CETAK PDF</a></li>
                        <?php } ?>

                        <?php if($level=='guru'){ ?>
                        <li><a href="media.php?module=absen"><i class="fa fa-edit fa-fw"></i> Input Absensi Siswa</a></li>
                        <li><a href="media.php?module=jadwal_mengajar"><i class="fa fa-calendar fa-fw"></i> Jadwal Mengajar Saya</a></li>
                        <?php } ?>

                        <?php if($level=='user'){ ?>
                        <li><a href="media.php?module=profil_siswa"><i class="fa fa-user fa-fw"></i> Profil Saya</a></li>
                        <li><a href="media.php?module=jadwal_siswa"><i class="fa fa-calendar fa-fw"></i> Jadwal Pelajaran</a></li>
                        <li><a href="media.php?module=riwayat_absensi"><i class="fa fa-list fa-fw"></i> Riwayat Absensi</a></li>
                        <?php } ?>

                        <?php if($level=='admin'){ ?>
                        <li>
                            <a href="#"><i class="fa fa-users fa-fw"></i> Data Siswa<span class="fa arrow"></span></a>
                            <ul class="nav nav-second-level">
                                <li><a href="media.php?module=input_siswa&act=input">Input Siswa</a></li>
                                <li><a href="media.php?module=tampil">Lihat Siswa</a></li>
                            </ul>
                        </li>
                        <li>
                            <a href="#"><i class="fa fa-user fa-fw"></i> Data Guru<span class="fa arrow"></span></a>
                            <ul class="nav nav-second-level">
                                <li><a href="media.php?module=input_guru&act=input">Input Guru</a></li>
                                <li><a href="media.php?module=guru">Lihat Guru</a></li>
                            </ul>
                        </li>
                        <li>
                            <a href="#"><i class="fa fa-table fa-fw"></i> Data Akademik<span class="fa arrow"></span></a>
                            <ul class="nav nav-second-level">
                                <li><a href="media.php?module=kelas">Data Kelas</a></li>
                                <li><a href="media.php?module=mata_pelajaran">Data Mata Pelajaran</a></li>
                                <li><a href="media.php?module=senin">Jadwal Pelajaran</a></li>
                            </ul>
                        </li>
                        <li><a href="media.php?module=sekolah"><i class="fa fa-building fa-fw"></i> Data Sekolah</a></li>
                        <?php } ?>
                    </ul>
                </div>
            </div>
        </nav>

        <div id="page-wrapper">
            <br>
            <?php include "content.php"; ?>
        </div>
    </div>

    <script src="js/jquery-1.10.2.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/plugins/metisMenu/jquery.metisMenu.js"></script>
    <script src="js/plugins/dataTables/jquery.dataTables.js"></script>
    <script src="js/plugins/dataTables/dataTables.bootstrap.js"></script>
    <script src="js/sb-admin.js"></script>
    
    <script>
        $(document).ready(function() {
            if ($('#dataTables-example').length > 0) {
                $('#dataTables-example').dataTable({
                    "bSort": true,
                    "bPaginate": true,
                    "bFilter": true,
                    "bInfo": true,
                    "language": {
                        "paginate": {
                            "previous": "Previous",
                            "next": "Next"
                        }
                    }
                });
            }
        });
    </script>
</body>
</html>
<?php 
} else {
    echo "<center><h2>Anda Harus Login Terlebih Dahulu</h2><a href='index.php'><b>Klik ini untuk Login</b></a></center>";
}
?>