<?php
// Pengaman: Pastikan ID adalah angka
$idj = isset($_GET['idj']) ? intval($_GET['idj']) : 0;

// Ambil info jadwal untuk judul laporan
$sql_info = mysqli_query($koneksi, "SELECT jadwal.*, kelas.nama AS nama_kelas, mata_pelajaran.nama_mp 
                                    FROM jadwal 
                                    JOIN kelas ON jadwal.idk=kelas.idk 
                                    JOIN mata_pelajaran ON jadwal.idm=mata_pelajaran.idm 
                                    WHERE idj='$idj'");
$info = mysqli_fetch_array($sql_info);

// Jika data jadwal tidak ditemukan (mencegah error halaman kosong)
if (!$info) {
    echo "<div class='alert alert-danger'>Data jadwal tidak ditemukan.</div>";
    exit;
}
?>

<div class="row">
    <div class="col-lg-12">
        <h3 class="page-header">Rekap Absensi: <?= $info['nama_mp'] ?> (Kelas <?= $info['nama_kelas'] ?>)</h3>
        
        <button onclick="window.print()" class="btn btn-success pull-right">
            <i class="fa fa-print"></i> Cetak Laporan
        </button>
        <br><br>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">
        <div class="panel panel-default">
            <div class="panel-body">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr class="bg-info">
                                <th class="text-center" width="50">No</th>
                                <th class="text-center">NIS</th>
                                <th>Nama Siswa</th>
                                <th class="text-center">Hadir</th>
                                <th class="text-center">Izin</th>
                                <th class="text-center">Sakit</th>
                                <th class="text-center">Alpa</th>
                            </tr>
                        </thead>
                        <tbody>
<?php
$no = 1;
// Ambil siswa sesuai kelas jadwal
$sql_siswa = mysqli_query($koneksi, "SELECT * FROM siswa WHERE idk='{$info['idk']}' ORDER BY nama ASC");

while($s = mysqli_fetch_array($sql_siswa)){
    // Hitung total kehadiran per siswa berdasarkan status di database
    // M = Masuk (Hadir), I = Izin, S = Sakit, A = Alpa
    $h = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM absen WHERE ids='$s[ids]' AND idj='$idj' AND ket='M'")); 
    $i = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM absen WHERE ids='$s[ids]' AND idj='$idj' AND ket='I'"));
    $skt = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM absen WHERE ids='$s[ids]' AND idj='$idj' AND ket='S'"));
    $a = mysqli_num_rows(mysqli_query($koneksi, "SELECT * FROM absen WHERE ids='$s[ids]' AND idj='$idj' AND ket='A'"));
?>
                            <tr>
                                <td class="text-center"><?= $no++ ?></td>
                                <td class="text-center"><?= $s['nis'] ?></td>
                                <td><?= $s['nama'] ?></td>
                                <td class="text-center"><?= $h ?></td>
                                <td class="text-center"><?= $i ?></td>
                                <td class="text-center"><?= $skt ?></td>
                                <td class="text-center"><?= $a ?></td>
                            </tr>
<?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
@media print {
    /* Sembunyikan elemen navigasi dan tombol saat dicetak */
    .btn, .navbar, #side-menu, .page-header { display: none !important; }
    
    /* Atur margin agar pas di kertas */
    #page-wrapper { margin: 0 !important; border: none; padding: 0 !important; }
    
    /* Pastikan tabel tercetak penuh */
    .panel { border: none !important; box-shadow: none !important; }
    
    /* Judul khusus cetak (muncul hanya saat print) */
    body:before {
        content: "Laporan Rekap Absensi - <?= $info['nama_mp'] ?> Kelas <?= $info['nama_kelas'] ?>";
        font-weight: bold;
        font-size: 14pt;
        display: block;
        text-align: center;
        margin-bottom: 20px;
    }
}
</style>