<div class="row mb-3">
    <div class="col-lg-12">
        <h3 class="page-header"><strong>Input Data Absensi</strong></h3>
    </div>
</div>

<?php
// 1. Pastikan ID Jadwal ada di URL
if (!isset($_GET['idj'])) {
    echo "<div class='alert alert-danger'>Jadwal tidak ditemukan!</div>";
    exit;
}

$idj = intval($_GET['idj']);

// 2. Ambil detail jadwal (Join Kelas & Mapel)
$dataquery = mysqli_query($koneksi, "
    SELECT j.*, k.nama AS nama_kelas, mp.nama_mp 
    FROM jadwal j
    JOIN kelas k ON j.idk = k.idk
    JOIN mata_pelajaran mp ON j.idm = mp.idm
    WHERE j.idj = '$idj'
");
$arrayj = mysqli_fetch_assoc($dataquery);

// Validasi jika jadwal tidak ada di database
if (!$arrayj) {
    echo "<div class='alert alert-danger'>Data jadwal tidak valid!</div>";
    exit;
}

echo "<div class='mb-3'>Kelas: <strong>".htmlspecialchars($arrayj['nama_kelas'])."</strong> | Mata Pelajaran: <strong>".htmlspecialchars($arrayj['nama_mp'])."</strong></div>";

$tg = date("Y-m-d");

// 3. Ambil siswa di kelas tersebut
$sqlsiswa = mysqli_query($koneksi, "SELECT * FROM siswa WHERE idk='{$arrayj['idk']}' ORDER BY nama ASC");
?>

<div class="row">
    <div class="col-lg-12">
        <div class="panel panel-primary">
            <div class="panel-heading">Formulir Absensi Siswa - Tanggal: <?= date('d/m/Y') ?></div>
            <div class="panel-body">
                
                <form method="post" action="./module/simpan.php?act=input_absen">
                    
                    <input type="hidden" name="idj" value="<?= $idj ?>">
                    <input type="hidden" name="tanggal" value="<?= $tg ?>"> 
                    
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover">
                            <thead>
                                <tr class="bg-info">
                                    <th width="50" class="text-center">No</th>
                                    <th width="150" class="text-center">NIS</th>
                                    <th>Nama Siswa</th>
                                    <th width="350" class="text-center">Keterangan</th>
                                </tr>
                            </thead>
                            <tbody>
<?php
$no = 1;
while ($rs = mysqli_fetch_assoc($sqlsiswa)) :
    // Cek apakah sudah pernah absen hari ini
    $sqla = mysqli_query($koneksi, "SELECT ket FROM absen WHERE ids='{$rs['ids']}' AND tgl='$tg' AND idj='$idj'");
    $rsa = mysqli_fetch_assoc($sqla);
    
    // Default 'H' (Hadir) jika belum ada data, biar guru tidak capek klik satu-satu
    $ket_sekarang = isset($rsa['ket']) ? $rsa['ket'] : 'M'; // M = Masuk/Hadir

    // Array Pilihan: Value Database => Label Tampilan
    // Pastikan Value (M, I, S, A) sesuai dengan yang diterima database
    $opsi = ['M'=>'Hadir', 'I'=>'Izin', 'S'=>'Sakit', 'A'=>'Alpa'];
?>
                                <tr>
                                    <td class="text-center"><?= $no++; ?></td>
                                    <td class="text-center"><?= htmlspecialchars($rs['nis']); ?></td>
                                    <td><?= htmlspecialchars($rs['nama']); ?></td>
                                    <td class="text-center">
<?php
    foreach ($opsi as $val => $label) :
        $checked = ($ket_sekarang == $val) ? 'checked' : '';
?>
                                        <label class="radio-inline" style="margin-right: 10px;">
                                            <input type="radio" name="ket[<?= $rs['ids'] ?>]" value="<?= $val ?>" <?= $checked ?>> <?= $label ?>
                                        </label>
<?php endforeach; ?>
                                    </td>
                                </tr>
<?php endwhile; ?>
                            </tbody>
                        </table>
                        <hr>
                        <button type="submit" class="btn btn-success btn-lg">
                            <i class="fa fa-save"></i> Simpan Data Absen
                        </button>
                        <a href="media.php?module=jadwal_mengajar" class="btn btn-danger btn-lg">Batal</a>
                    </div>
                </form>

                <br>
                <div class="alert alert-info">
                    <strong>Keterangan Kode:</strong><br>
                    Hadir (M) | Izin (I) | Sakit (S) | Alpa (A)
                </div>
            </div>
        </div>
    </div>
</div>