<?php
// 1. Panggil koneksi database (Sesuaikan nama file koneksi kamu!)
// Biasanya bernama 'koneksi.php' atau 'config/koneksi.php'
include 'koneksi.php'; 

// 2. Panggil library TCPDF
require_once('tcpdf/tcpdf.php');

// 3. Setup PDF
$pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);

// Set properti dokumen
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Admin Sekolah');
$pdf->SetTitle('Laporan Absensi Siswa');

// Hapus header/footer default (opsional, agar lebih bersih)
$pdf->setPrintHeader(false);
$pdf->setPrintFooter(false);

// Set margin (Kiri, Atas, Kanan)
$pdf->SetMargins(15, 15, 15);

// Tambah Halaman
$pdf->AddPage();

// 4. Buat Judul Laporan
$pdf->SetFont('helvetica', 'B', 16);
$pdf->Cell(0, 10, 'LAPORAN DATA ABSENSI SISWA', 0, 1, 'C');
$pdf->SetFont('helvetica', '', 10);
$pdf->Cell(0, 5, 'SMK Al-Hidayah (Contoh Sekolah)', 0, 1, 'C');
$pdf->Ln(10); // Spasi ke bawah

// 5. Siapkan Kepala Tabel HTML
$html = '
<table border="1" cellpadding="5">
    <tr style="background-color:#cccccc; font-weight:bold;">
        <td width="10%" align="center">No</td>
        <td width="20%">NIS</td>
        <td width="30%">Nama Siswa</td>
        <td width="20%">Kelas</td>
        <td width="20%" align="center">Keterangan</td>
    </tr>';

// 6. Ambil Data dari Database
// GANTI QUERY INI sesuai nama tabel di databasemu
// Contoh: SELECT * FROM tb_siswa JOIN tb_absensi ...
$no = 1;
$query = mysqli_query($koneksi, "SELECT * FROM siswa"); 

// Cek apakah query berhasil
if ($query) {
    while ($row = mysqli_fetch_array($query)) {
        // Ganti $row['...'] sesuai nama kolom di database kamu
        $nis = isset($row['nis']) ? $row['nis'] : '-';
        $nama = isset($row['nama_siswa']) ? $row['nama_siswa'] : '-';
        $kelas = isset($row['kelas']) ? $row['kelas'] : '-';
        
        // Contoh logika keterangan (bisa disesuaikan)
        $ket = "Hadir"; 

        $html .= '
        <tr>
            <td align="center">'.$no++.'</td>
            <td>'.$nis.'</td>
            <td>'.$nama.'</td>
            <td>'.$kelas.'</td>
            <td align="center">'.$ket.'</td>
        </tr>';
    }
} else {
    $html .= '<tr><td colspan="5" align="center">Data tidak ditemukan atau Query Error</td></tr>';
}

$html .= '</table>';

// 7. Cetak HTML ke PDF
$pdf->writeHTML($html, true, false, true, false, '');

// 8. Output file
$pdf->Output('laporan_absensi.pdf', 'I');
?>